/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.entity.KoboldSkeletonEntity;

public class SkeleboldModel<T extends Monster>
extends HumanoidModel<T> {
    public static final ModelLayerLocation SKELEBOLD_MODEL = new ModelLayerLocation(new ResourceLocation("kobolds", "skelebold"), "main");

    public SkeleboldModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = KoboldModel.createMesh(CubeDeformation.f_171458_, 0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition rightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(46, 16).m_171488_(-2.01f, -0.85f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)5.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(33, 16).m_171488_(0.01f, -0.85f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)5.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(13, 31).m_171488_(-1.0f, -0.01f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)14.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-1.0f, -0.01f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)14.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(3, 15).m_171488_(-3.0f, 0.0f, -2.0f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(24, 15).m_171488_(-0.5f, 6.0f, -4.0f, 1.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T kobold, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.f_102811_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.f_102812_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.f_102811_.f_104204_ = 0.0f;
        this.f_102811_.f_104205_ = 0.0f;
        this.f_102812_.f_104204_ = 0.0f;
        this.f_102812_.f_104205_ = 0.0f;
        this.f_102813_.f_104203_ = 0.0f;
        this.f_102814_.f_104203_ = 0.0f;
        this.f_102813_.f_104204_ = 0.0f;
        this.f_102814_.f_104204_ = 0.0f;
        this.f_102810_.f_104203_ = 0.0f;
        this.f_102810_.f_104204_ = 0.0f;
        this.f_102810_.f_104205_ = 0.0f;
        this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.f_102808_.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.f_102809_.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.f_102809_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.f_102811_.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        this.f_102812_.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        if (this.f_102609_) {
            this.f_102813_.f_104203_ = -1.5708f;
            this.f_102814_.f_104203_ = -1.5708f;
            this.f_102813_.f_104204_ = 0.2618f;
            this.f_102814_.f_104204_ = -0.2618f;
        }
        if (kobold.m_21033_(EquipmentSlot.MAINHAND)) {
            if (kobold.m_5912_()) {
                if (kobold.m_21526_()) {
                    this.f_102812_.f_104203_ = -2.0944f;
                    this.f_102812_.f_104204_ = -0.1745f;
                } else {
                    this.f_102811_.f_104203_ = -2.0944f;
                    this.f_102811_.f_104204_ = 0.1745f;
                }
            } else if (kobold.m_21205_().m_41720_() instanceof CrossbowItem && kobold instanceof KoboldSkeletonEntity) {
                KoboldSkeletonEntity kevin = (KoboldSkeletonEntity)((Object)kobold);
                if (kevin.m_21526_()) {
                    if (kevin.isCharging()) {
                        this.f_102812_.f_104203_ = -0.6981f;
                        this.f_102812_.f_104204_ = 0.3491f;
                        this.f_102811_.f_104203_ = -1.1345f;
                        this.f_102811_.f_104204_ = -0.5672f;
                    } else if (CrossbowItem.m_40932_((ItemStack)kevin.m_21205_())) {
                        this.f_102812_.f_104203_ = -1.4399f;
                        this.f_102812_.f_104204_ = 0.2618f;
                        this.f_102811_.f_104203_ = -1.3963f;
                        this.f_102811_.f_104204_ = -0.3054f;
                    }
                } else if (kevin.isCharging()) {
                    this.f_102811_.f_104203_ = -0.6981f;
                    this.f_102811_.f_104204_ = -0.3491f;
                    this.f_102812_.f_104203_ = -1.1345f;
                    this.f_102812_.f_104204_ = 0.5672f;
                } else if (CrossbowItem.m_40932_((ItemStack)kevin.m_21205_())) {
                    this.f_102811_.f_104203_ = -1.4399f;
                    this.f_102811_.f_104204_ = -0.2618f;
                    this.f_102812_.f_104203_ = -1.3963f;
                    this.f_102812_.f_104204_ = 0.3054f;
                }
            }
        }
        if (this.f_102608_ > 0.0f) {
            if (kobold.m_21526_()) {
                float progress = this.f_102608_;
                progress = 1.0f - this.f_102608_;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.m_14031_((float)(progress * (float)Math.PI));
                this.f_102812_.f_104203_ = (float)((double)this.f_102812_.f_104203_ - ((double)f2 / 1.2 - 1.0));
            } else {
                float progress = this.f_102608_;
                progress = 1.0f - this.f_102608_;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.m_14031_((float)(progress * (float)Math.PI));
                this.f_102811_.f_104203_ = (float)((double)this.f_102811_.f_104203_ - ((double)f2 / 1.2 - 1.0));
            }
        }
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        switch (arm) {
            case LEFT: {
                this.f_102812_.m_104299_(poseStack);
                poseStack.m_85837_(0.045, 0.096, 0.0);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
                break;
            }
            case RIGHT: {
                this.f_102811_.m_104299_(poseStack);
                poseStack.m_85837_(-0.045, 0.096, 0.0);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.f_102808_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102809_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102810_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102811_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102813_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102812_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102814_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

